% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiomodClass.R
\docType{class}
\name{BIOMOD.EnsembleModeling.out-class}
\alias{BIOMOD.EnsembleModeling.out-class}
\alias{BIOMOD.EnsembleModeling.out}
\alias{show,BIOMOD.EnsembleModeling.out-method}
\title{BIOMOD_EnsembleModeling() outputs objects class}
\usage{
\S4method{show}{BIOMOD.EnsembleModeling.out}(object)
}
\arguments{
\item{object}{a BIOMOD.EnsembleModeling.out object}
}
\description{
EnsembleModeling objects are created, used and returned by BIOMOD
functions. It's contains information relative to an \pkg{biomod2}
ensemble modeling procedure.

- output of: \code{\link[biomod2]{BIOMOD_EnsembleModeling}}
- input of: \code{\link[biomod2]{BIOMOD_EnsembleForecasting}}
}
\section{Slots}{

\describe{
\item{\code{sp.name}}{"character", species name}

\item{\code{expl.var.names}}{"character", explanatory variables
names}

\item{\code{models.out.obj}}{"BIOMOD.stored.models.out", object which
contains information on individuals models that have been combined}

\item{\code{eval.metric}}{"character", evaluation metrics chose for
models selection}

\item{\code{eval.metric.quality.threshold}}{"numeric", thresholds
defined for models selection}

\item{\code{em.computed}}{"character", ensemble models built names}

\item{\code{em.by}}{"character", way models are combined}

\item{\code{em.models}}{"ANY", list of built biomod2.ensemble.models
objects}

\item{\code{modeling.id}}{"character", the id of the whole
modelling process}

\item{\code{link}}{"character", the path to corresponding hard drive
saved object}
}}

\examples{
showClass("BIOMOD.EnsembleModeling.out")

}
\seealso{
\code{\link[biomod2]{BIOMOD_Projection}}, 
\code{\link[biomod2]{BIOMOD_Modeling}}, 
\code{\link[biomod2]{BIOMOD_EnsembleModeling}}, 
\code{\link[biomod2]{BIOMOD_EnsembleForecasting}}
}
\author{
Damien Georges
}
\keyword{ensemble}
\keyword{models}
