% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGroups.R
\name{getGroups}
\alias{getGroups}
\title{Retrieve available groups for a kingdom of life}
\usage{
getGroups(db = "refseq", kingdom)
}
\arguments{
\item{db}{a character string specifying the database from which the genome 
shall be retrieved: 
\itemize{
\item \code{db = "refseq"}
\item \code{db = "genbank"}
}

Default is \code{db = "refseq"}.}

\item{kingdom}{a character string specifying for which kingdom of life 
groups shall be retrieved. See \code{\link{getKingdoms}} for details.}
}
\description{
A short list of available groups for a kingdom of life.
}
\examples{
# get possible kigdom names
getKingdoms(db = "refseq")
\dontrun{
# retrieve subgroups for vertebrate_mammalian available from refseq
getGroups(db = "refseq", kingdom = "vertebrate_mammalian")

# get possible kigdom names
getKingdoms(db = "genbank")
# retrieve subgroups for vertebrate_mammalian available from genbank
getGroups(db = "genbank", kingdom = "vertebrate_mammalian")
}
}
\seealso{
\code{\link{meta.retrieval}}, \code{\link{getGenome}}, 
\code{\link{getProteome}}, \code{\link{getCDS}}, \code{\link{getKingdoms}}
}
\author{
Hajk-Georg Drost
}
