% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_genome.R
\name{read_genome}
\alias{read_genome}
\title{Import Genome Assembly as Biostrings or data.table object}
\usage{
read_genome(file, format = "fasta", obj.type = "Biostrings", ...)
}
\arguments{
\item{file}{a character string specifying the path to the file storing the genome.}

\item{format}{a character string specifying the file format used to store the genome, e.g. \code{format = "fasta"} (default) or \code{format = "gbk"}.}

\item{obj.type}{a character string specifying the object stype in which the genomic sequence shall be represented. 
Either as \code{obj.type = "Biostrings"} (default) or as \code{obj.type = "data.table"}.}

\item{...}{additional arguments that are used by the seqinr::read.fasta() function.}
}
\value{
Either a \code{Biostrings} or \code{data.table} object.
}
\description{
This function reads an organism specific genome stored in a defined file format.
}
\details{
This function takes a string specifying the path to the genome file
of interest as first argument (e.g. the path returned by \code{\link{getGenome}}).
}
\examples{
\dontrun{
# reading a genome stored in a fasta file
Ath.genome <- read.genome(system.file('seqs/ortho_thal_cds.fasta', package = 'orthologr'),
                           format = "fasta")
                           
Ath.genome
}

}
\author{
Hajk-Georg Drost
}
\seealso{
\code{\link{getGenome}}, \code{\link{read_proteome}}, \code{\link{read_cds}}, \code{\link{read_gff}}
}

