% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/weibull-mafart_model.R
\name{dMafart_model}
\alias{dMafart_model}
\title{First Derivate of the Weibull-Mafart Model}
\usage{
dMafart_model(t, x, parms, temp_profile)
}
\arguments{
\item{t}{numeric vector indicating the time of the experiment.}

\item{x}{list with the value of N at t.}

\item{parms}{parameters for the secondary model. No explicit check of their validity
is performed (see section \bold{Model Parameters}).}

\item{temp_profile}{a function that provides the temperature at a given time.}
}
\value{
The value of the first derivative of N at time \code{t} as a list.
}
\description{
Calculates the first derivative of Weibull-Mafart model at a given time for
the model parameters provided and the environmental conditions given.
}
\details{
The model is developed from the isothermal Weibull-Mafart model without
taking into
account in the derivation the time dependence of \eqn{\delta_T} for
non-isothermal temperature profiles.

This function is compatible with the function
\code{\link{predict_inactivation}}.
}
\section{Model Equation}{


     \deqn{\frac{dN}{dt} = -N \cdot p \cdot (1/\delta)^p \cdot t^{p-1} }{
           dN/dt = -N * p * (1/delta)^p * t^(p-1)}

     \deqn{\delta(T) = \delta_{ref} \cdot 10^{- (T-T_ref)/z} }{
           delta(T) = delta_ref * 10^(- (T-T_ref)/z )}
}

\section{Model Parameters}{

     \itemize{
         \item temp_ref: Reference temperature for the calculation.
         \item delta_ref: Value of the scale factor at the reference temperature.
         \item z: z-value.
         \item p: shape factor of the Weibull distribution.
         }
}

\section{Note}{

     For t=0, dN = 0 unless n=1. Hence, a small shift needs to be introduced
     to t.
}
\seealso{
\code{\link{predict_inactivation}}
}

