% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_ed.R
\name{calc_pi}
\alias{calc_pi}
\title{Calculate partition index}
\usage{
calc_pi(a, b)
}
\arguments{
\item{a}{encoding (see \code{\link{validate_encoding}} for more information 
about the required structure of encoding).}

\item{b}{encoding to which \code{a} should be compared. Must have equal number 
of groups or less than \code{a}. Both \code{a} and {b} must have the the same 
number of elements.}
}
\value{
an encoding distance.
}
\description{
Computes the encoding distance between two encodings.
}
\details{
The encoding distance between \code{a} and \code{b} is defined as the 
minimum number of amino acids that have to be moved between subgroups of encoding 
to make \code{a} identical to \code{b} (order of subgroups in the encoding and amino 
acids in a group is unimportant).

If the parameter \code{prop} is supplied, the encoding distance is normalized by the 
factor equal to the sum of distances for each group in \code{a} and the closest group 
in \code{b}. The position of a group is defined as the mean value of properties of 
amino acids or nucleotides belonging the group.

See the package vignette for more details.
}
\examples{
# calculate encoding distance between two encodings of amino acids
aa1 = list(`1` = c("g", "a", "p", "v", "m", "l", "i"), 
           `2` = c("k", "h"), 
           `3` = c("d", "e"), 
           `4` = c("f", "r", "w", "y", "s", "t", "c", "n", "q"))

aa2 = list(`1` = c("g", "a", "p", "v", "m", "l", "q"), 
           `2` = c("k", "h", "d", "e", "i"), 
           `3` = c("f", "r", "w", "y", "s", "t", "c", "n"))
calc_pi(aa1, aa2) 
    
# the encoding distance between two identical encodings is 0
calc_pi(aa1, aa1) 
 
}
\seealso{
\code{\link{calc_si}}: compute the similarity index of two encodings.
\code{\link{encoding2df}}: converts an encoding to a data frame.
\code{\link{validate_encoding}}: validate a structure of an encoding.
}
