% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chi_square.R
\name{calc_cs}
\alias{calc_cs}
\title{Calculate Chi-squared-based measure}
\usage{
calc_cs(feature, target_b, len_target, pos_target)
}
\arguments{
\item{feature}{feature vector.}

\item{target_b}{target in bits (as per \code{\link[bit]{as.bit}}).}

\item{len_target}{length of the target vector.}

\item{pos_target}{number of positive cases in the target vector.}
}
\value{
A \code{numeric} vector of length 1 representing computed Chi-square values.
}
\description{
Computes Chi-squared-based measure between features and target vector.
}
\note{
Both \code{target} and \code{features} must be binary, i.e. contain only 0 
and 1 values.

The function was designed to be as fast as possible subroutine of 
\code{\link{calc_criterion}} and might be cumbersome if directly called by a user.
}
\examples{
tar <- sample(0L:1, 100, replace = TRUE)
feat <- sample(0L:1, 100, replace = TRUE)
library(bit) # used to code vector as bit
calc_cs(feat, as.bit(tar), 100, sum(tar))
}
\seealso{
\code{\link{test_features}}.

\code{\link[stats]{chisq.test}} - Pearson's chi-squared test for count data.
}

