% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/add_ngrams.R
\name{add_1grams}
\alias{add_1grams}
\title{Add 1-grams}
\usage{
add_1grams(ngrams)
}
\arguments{
\item{ngrams}{a vector of positioned n-grams (as created by \code{\link{count_ngrams}}).}
}
\value{
a vector of n-grams (where \code{n} is equal to the \code{n} of the input plus one)
with position information.
}
\description{
Builds (n+1)-grams from n-grams.
}
\details{
n-grams are built by pasting existing n-grams with unigrams extracted
from them.
}
\note{
All n-grams must have the same length (\code{n}).
}
\examples{
add_1grams(c("1_1_0", "2_1_0", "5_1_0", "7_1_0", "4_2_0",
"5_2_0", "7_2_0", "8_5_0"))
add_1grams(c("1_2.3.4_0.0", "4_1.1.1_0.0"))
}
\seealso{
Function used by \code{add_1grams} to extract unigrams: \code{\link{position_ngrams}}.
}

