% Generated by roxygen2 (4.0.2): do not edit by hand
\name{degenerate}
\alias{degenerate}
\title{Degenerate protein sequence}
\usage{
degenerate(seq, element_groups)
}
\arguments{
\item{seq}{\code{character} vector or matrix representing single sequence.}

\item{element_groups}{list of groups to which elements of sequence should be aggregated.}
}
\value{
a \code{character} vector or matrix (if input is a matrix)
containing aggregated elements.
}
\description{
'Degenerates' amino acid or nucleic sequence by aggregating
elements to bigger groups.
}
\note{
Both sequence and \code{element_groups} should contain lower-case letters.
Upper-case will be automatically converted without a message.
}
\examples{
sample_seq <- c(1, 3, 1, 3, 4, 4, 3, 1, 2)
table(sample_seq)

#aggregate sequence to purins and pyrimidines
deg_seq <- degenerate(sample_seq, list(w = c(1, 4), s = c(2, 3)))
table(deg_seq)
}
\seealso{
\code{\link{l2n}} to easily convert information stored in biological sequences from
letters to numbers.
}
\keyword{manip}

