% Generated by roxygen2 (4.0.2): do not edit by hand
\name{create_ngrams}
\alias{create_ngrams}
\title{Get All Possible N-Grams}
\usage{
create_ngrams(n, u, possible_grams = NULL)
}
\arguments{
\item{n}{\code{integer} size of n-gram.}

\item{u}{unigrams (\code{integer}, \code{numeric} or \code{character} vector).}

\item{possible_grams}{number of possible n-grams. If not \code{NULL} n-grams do not
contain information about position}
}
\value{
a character vector. Elements of n-gram are separated by dot.
}
\description{
Creates vector of all posible n_grams (for given \code{n}).
}
\details{
See Details section of \code{\link{count_ngrams}} for more
information about n-grams naming convention.
}
\note{
Input data must be a matrix or data frame of numeric elements.
}
\examples{
#bigrams for standard aminoacids
create_ngrams(2, 1L:20)
#bigrams for standard aminoacids with positions, 10 nucleotide long sequence
create_ngrams(2, 1L:20, 9)
}

