% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcs_fitting.R
\name{fit}
\alias{fit}
\title{Perform dose-effect fitting algorithm}
\usage{
fit(
  count_data,
  model_formula,
  model_family,
  fit_link = "identity",
  aberr_module,
  algorithm = c("glm", "maxlik")
)
}
\arguments{
\item{count_data}{Count data in data frame form.}

\item{model_formula}{Model formula.}

\item{model_family}{Model family.}

\item{fit_link}{Family link.}

\item{aberr_module}{Aberration module.}

\item{algorithm}{Optional selection of algorithm to be used, either "glm" (for GLM) or "maxlik" (for MLE). By default, "glm" is used, with "maxlik" as a fallback method.}
}
\value{
List object containing fit results either using GLM or maxLik optimization.
}
\description{
Perform dose-effect fitting. A generalized linear model (GLM) is used by
default, with a maximum likelihood estimation (MLE) as a fallback method.
}
\details{
The GLM method is based on the paper by Edwards, A. A. et al. (1979).
Radiation induced chromosome aberrations and the Poisson distribution.
Radiation and Environmental Biophysics, 16(2), 89-100.
<doi:10.1007/BF01323216>.

The MLE method is based on the paperby Oliveira, M. et al. (2016).
Zero-inflated regression models for radiation-induced chromosome aberration
data: A comparative study. Biometrical Journal, 58(2), 259-279.
<doi:10.1002/bimj.201400233>.
}
