% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compose-io.R
\name{compose_io_v1.3.0}
\alias{compose_io_v1.3.0}
\alias{compose_io}
\title{Compose BioCompute Object - Input and Output Domain (v1.3.0)}
\usage{
compose_io_v1.3.0(input = NULL, output = NULL)

compose_io(input = NULL, output = NULL)
}
\arguments{
\item{input}{Data frame. Variables include
\code{filename}, \code{uri}, and \code{access_time}.
Each row is one item in the input subdomain.}

\item{output}{Data frame. Variables include
\code{mediatype}, \code{uri}, and \code{access_time}.
Each row is one item in the output subdomain.}
}
\value{
A list of class \code{bco.domain}
}
\description{
This domain contains the list of global input and output files
created by the computational workflow, excluding the intermediate files.
}
\examples{
input_subdomain <- data.frame(
  "filename" = c(
    "Hepatitis C virus genotype 1",
    "Hepatitis C virus type 1b complete genome"
  ),
  "uri" = c(
    "https://www.ncbi.nlm.nih.gov/nuccore/22129792",
    "https://www.ncbi.nlm.nih.gov/nuccore/5420376"
  ),
  "access_time" = c(
    as.POSIXct("2017-01-24T09:40:17", format = "\%Y-\%m-\%dT\%H:\%M:\%S", tz = "EST"),
    as.POSIXct("2017-01-24T09:40:17", format = "\%Y-\%m-\%dT\%H:\%M:\%S", tz = "EST")
  ),
  stringsAsFactors = FALSE
)

output_subdomain <- data.frame(
  "mediatype" = c("text/csv", "text/csv"),
  "uri" = c(
    "https://example.com/data/514769/dnaAccessionBased.csv",
    "https://example.com/data/514801/SNPProfile*.csv"
  ),
  "access_time" = c(
    as.POSIXct("2017-01-24T09:40:17", format = "\%Y-\%m-\%dT\%H:\%M:\%S", tz = "EST"),
    as.POSIXct("2017-01-24T09:40:17", format = "\%Y-\%m-\%dT\%H:\%M:\%S", tz = "EST")
  ),
  stringsAsFactors = FALSE
)

compose_io(input_subdomain, output_subdomain) \%>\% convert_json()
}
