% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectro.R
\name{fspec}
\alias{fspec}
\title{Generate spectrograms}
\usage{
fspec(wave, channel = "left", FFT_size = 256, FFT_overlap = 0.875,
  FFT_win = "hann", LPF, HPF = 0, tlim = NULL, flim = NULL,
  rotate = FALSE, to_dB = TRUE)
}
\arguments{
\item{wave}{a \link[tuneR]{Wave} object.}

\item{channel}{character. Channel to keep for analysis in a stereo recording: "left" or "right". Default setting is left.}

\item{FFT_size}{integer. Size of the Fast Fourrier Transform (FFT) window. Default setting is 256.}

\item{FFT_overlap}{numeric. Percentage of overlap between two FFT windows (from 0 to 1). Default setting is 0.875.}

\item{FFT_win}{character. Specify the type of FFT window: "hann", "blackman4", or "blackman7".
Default setting is "hann".}

\item{LPF}{integer. Low-Pass Filter (Hz). Frequencies above the cutoff are greatly attenuated.
Default setting is the Nyquist frequency of the recording.}

\item{HPF}{integer. High-Pass Filter (Hz). Frequencies below the cutoff are greatly attenuated.
Default setting is 0 Hz.}

\item{tlim}{numeric. Specify the time limits on the X-axis in seconds (s).
Default setting is \code{NULL}, i.e no time limits.}

\item{flim}{numeric. Specify the frequency limits on the Y-axis in Hz. Default
setting is \code{NULL}, i.e. frequency limits are equal to \code{c(0, LPF)}.}

\item{rotate}{logical. Should the matrix be rotated 90° counter clockwise ?
Default setting is \code{FALSE}.}

\item{to_dB}{logical. Convert magnitude values to decibels (dB)? Default is \code{TRUE}.}
}
\value{
A matrix of amplitude or decibel (dB) values in the time / frequency domain.
}
\description{
This function returns the spectrographic representation of a time wave in the absolute scale or in decibels (dB) using the Fast Fourier transform (FFT).
}
\examples{
data(myotis)
image(fspec(myotis, tlim = c(1, 2), rotate = TRUE))

}
