% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{filter_vpts}
\alias{filter_vpts}
\title{Time selection in a time series of vertical profiles ('vpts')}
\usage{
filter_vpts(x, min, max, nearest)
}
\arguments{
\item{x}{A \code{vpts} object.}

\item{min}{Minimum datetime to be included. POSIXct value or charater string convertable to POSIXct.}

\item{max}{Maximum datetime to be included. POSIXct value or charater string convertable to POSIXct.}

\item{nearest}{If specified, \code{min} and \code{max} are ignored and the profile nearest to the
specified datetime is returned. POSIXct value or charater string convertable to POSIXct.}
}
\value{
An object of class '\link[=summary.vpts]{vpts}', or an object of class '\link[=summary.vp]{vp}'
if argument \code{nearest} is specified.
}
\description{
Time selection in a time series of vertical profiles ('vpts')
}
\details{
returns profiles for which min <= timestamp profile < max.
}
\examples{
# load example vertical profile time series:
data(example_vpts)
example_vpts

# select profiles later than 02-Sep-2016
filter_vpts(example_vpts, min = "2016-09-02")

# select the profile nearest to 2016-09-01 03:00 UTC:
filter_vpts(example_vpts, nearest = "2016-09-01 03:00")

# select profiles between than 1 and 3 UTC on 02-Sep-2016:
filter_vpts(example_vpts, min = "2016-09-02 01:00", max = "2016-09-02 03:00")
}
