% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_vpfiles.R
\name{read_vpfiles}
\alias{read_vpfiles}
\title{Read a vertical profile (\code{vp}) or a list of vertical profiles
(\code{vp}) from files}
\usage{
read_vpfiles(files)
}
\arguments{
\item{files}{A character vector containing the file names of
vertical profiles in ODIM HDF5 format generated by \link{calculate_vp}.}
}
\value{
A single \code{vp} object or a list of \code{vp} objects.
}
\description{
Read a vertical profile (\code{vp}) or a list of vertical profiles
(\code{vp}) from files
}
\examples{
\dontrun{
read_vpfiles("my/path/profile1.h5")
}
\dontrun{
read_vpfiles(c("my/path/profile1.h5", "my/path/profile2.h5", ...))
}

# locate example profile file:
vpfile <- system.file("extdata", "profile.h5", package = "bioRad")

# print the local path of the profile file:
vpfile

# load the file:
read_vpfiles(vpfile)
}
