% Generated by roxygen2 (4.0.1): do not edit by hand
\name{bins.quantiles}
\alias{bins.quantiles}
\title{Quantile-based binning}
\usage{
bins.quantiles(x, target.bins, max.breaks, verbose = FALSE)
}
\arguments{
\item{x}{A numeric vector to be cut in bins.}

\item{target.bins}{Target number of bins, which may not be reached if the
number of unique values is smaller than the specified value.}

\item{max.breaks}{Maximum number of quantiles; must be at least as
large as \code{target.bins}.}

\item{verbose}{Indicates verbose output.}
}
\description{
Cuts the data set x into roughly equal groups using quantiles.
}
\details{
Because the number of unique values may be smaller than target.bins,
the function gradually increases the number of quantiles up to max.breaks
or until the target.bins number of bins is reached.
}
\seealso{
\code{\link{binr}}, \code{\link{bins}}, \code{\link{bins.greedy}}, \code{\link{bins.optimize}}
}

