% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runEM.R
\name{runEM}
\alias{runEM}
\title{Run an EM algorithm to obtain a mixture of binomial with K clusters}
\usage{
runEM(formula, var_weights, K, df, col_id = "id")
}
\arguments{
\item{formula}{A formula or Character which links target variable and predictor variables}

\item{var_weights}{A character value corresponding to the weights variable}

\item{K}{A numeric value representing the number of clusters chosen for the mixture}

\item{df}{A dataframe to cluster}

\item{col_id}{A character value (colname) corresponding to the id column name}
}
\value{
a summary list of EM algorithm results : loglikelihood, beta/lambda/tau estimation at each iteration,
bic/icl value,number of fisher iteration at each EM iteration
}
\description{
This function is the main function of this package. 
The objective is to provide a clustering of the 80 campaigns that we have on our dataset.
The specification of this algorithm is that we can have longitudinal data, i.e n observations for a single campaign.
}
\examples{
## Load data :
data(adcampaign)
## Run mixture :
\dontrun{
result_mixture<-runEM(formula="ctr~timeSlot",
                      var_weights="impressions",
                      K=2,
                      df=adcampaign,
                      col_id="id")
## Analysis of results :
plot(result_mixture[[1]],type="l") #gives you the loglikelihood evolution
# list of the estimated parameter for each cluster for each iteration :
result_mixture[[2]]  
# list of the estimated parameter for each cluster for each iteration
result_mixture[[3]] #list of ids proportion in each cluster for each iteration
#list of matrices containing probability to be in cluster k for each id :
result_mixture[[4]] 
# BIC value :
result_mixture[[5]] 
# ICL value :
result_mixture[[6]] 
# list of number fisher scoring iterations for each iteration
result_mixture[[7]]
} 
}
