% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plugin_boot_densidad_2_FastGaussianMise2.R
\name{bw.dens.binned}
\alias{bw.dens.binned}
\title{Bootstrap and plug-in bandwidth selectors for kernel density estimation with binned data.}
\usage{
bw.dens.binned(n, y, w, ni, gboot, pilot.type = 3, hn = 100,
  plugin.type = "N", confband = FALSE, alpha = 0.05, B = 1000,
  plot = TRUE, print = TRUE, model, parallel = FALSE, pars = new.env())
}
\arguments{
\item{n}{Positive integer. Size of the complete sample.}

\item{y}{Vector. Observed values. They define the extremes of the sequence of intervals in which data is binned.}

\item{w}{Vector. Proportion of observations within each interval.}

\item{ni}{Vector. Number of observations within each interval.}

\item{gboot}{Positive real number. Pilot bandwidth for the bootstrap bandwidth selector.}

\item{pilot.type}{1, 2 or 3. If \code{gboot} is missing, pilot bandwidth for the bootstrap bandwidth selector is automatically selected using methods 1, 2 or 3. Defaults to 3. See details for more information.}

\item{hn}{Positive integer. Size of the grid of bandwidths for which MISE will be approximated. Defaults to 100.}

\item{plugin.type}{Character. If \code{plugin.type} = "N", normality is assumed at the last step when calculating the plug-in bandwidth. If \code{plugin.type} = "A", parameter at last step is estimated nonparametrically using \code{gplugin} as bandwidth. Otherwise, the unknown parameter is estimated fitting a normal mixture. Defaults to \code{type} = "N".}

\item{confband}{Logical. If TRUE, bootstrap confidence bands are constructed for the density function. Defaults to FALSE.}

\item{alpha}{Real number between 0 and 1. Significance level for the bootstrap confidence bands. Defaults to 0.05.}

\item{B}{Positive integer. Number of bootstrap resamples used when constructing confidence bands. Defaults to 1000.}

\item{plot}{Logical. If TRUE, kernel density estimators are plotted along with (optional) bootstrap confidence bands. Defaults to TRUE.}

\item{print}{Logical. If TRUE and confband is TRUE, the percentage of bootstrap resamples already evaluated is printed. Defaults to TRUE.}

\item{model}{Character. Name of the parametric family of distributions to be fitted for the grouped sample. Parameters are estimated by maximum likelihood.}

\item{parallel}{Logical. If TRUE, confidence bands are estimated using parallel computing with sockets.}

\item{pars}{Environment. Needed for the well functioning of the script. DO NOT modify this argument.}
}
\value{
A list with components
\item{h_boot}{Bootstrap bandwidth selector.}
\item{h_plugin}{Plug-in bandwidth selector.}
}
\description{
Bootstrap and plug-in bandwidth selectors for kernel density estimation with binned data.
}
\details{
If \code{pilot.type} = 1, an heuristic rule is used for calculating the pilot bandwidth. It's not recommended when population's density function is suspected to be highly multimodal.

If \code{pilot.type} = 2, the pilot bandwidth is such that the kernel density estimator with bandwidth \code{gboot} approximates the histogram of the grouped sample minimizing the residual sum of squares. If \code{pilot.type} = 3, a penalty is imposed on the curvature of the kernel density estimator with bandwidth \code{gboot}. The penalty parameter is selected as to best approximate the curvature of the true density.
}
\examples{
set.seed(1)
n <- 200 #complete sample size
k <- 30 #number of intervals
x <- rnorm(n,6,1) #complete sample
y <- seq(min(x)-0.2,max(x)+0.2,len=k+1) #intervals
w <- c(sapply(2:k,function(i)sum( x<y[i]&x>=y[i-1] )), sum(x<=y[k+1]&x>=y[k]) )/n #proportions
bw.dens.binned(n,y,w,plot=FALSE)

}
\references{
\insertRef{TesisMiguel2015}{binnednp}

\insertRef{JNS2016}{binnednp}

\insertRef{Test2017}{binnednp}
}
