% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outlier-dist.R
\name{maha_trans}
\alias{maha_trans}
\title{Transform matrix}
\usage{
maha_trans(U, estim = covrob_ogk(U))
}
\arguments{
\item{U}{A matrix (e.g. PC scores).}

\item{estim}{List of location and scatter estimates, \verb{$cov} and \verb{$center}.}
}
\value{
\code{U}, transformed.
}
\description{
Transform matrix to use Mahalanobis distance instead of Euclidean one.
}
\examples{
X <- readRDS(system.file("testdata", "three-pops.rds", package = "bigutilsr"))
svd <- svds(scale(X), k = 5)

U <- svd$u
dist1 <- dist_ogk(U)

U.maha <- maha_trans(U)
dist2 <- rowSums(U.maha^2)
all.equal(dist2, dist1)

}
