% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outlier-hist.R
\name{hist_out}
\alias{hist_out}
\title{Outlier detection (histogram)}
\usage{
hist_out(x, breaks = nclass.scottRob, pmax_out = 0.2, nboot = NULL)
}
\arguments{
\item{x}{Numeric vector (with compact values).}

\item{breaks}{Same parameter as for \code{hist()}. Default uses a robust version
of Scott's rule. You can also use \code{"FD"} or \code{nclass.FD} for a bit more bins.}

\item{pmax_out}{Percentage at each side that can be considered outliers at
each step. Default is \code{0.2}.}

\item{nboot}{Number of bootstrap replicates to estimate limits more robustly.
Default is \code{NULL} (no bootstrap, even if \strong{I would recommend to use it}).}
}
\value{
A list with
\itemize{
\item \code{x}: the initial vector, whose outliers have been removed,
\item \code{lim}: lower and upper limits for outlier remova,
\item \code{all_lim}: all bootstrap replicates for \code{lim} (if \code{nboot} not \code{NULL}).
}
}
\description{
Outlier detection based on departure from histogram.
Suitable for compact values (need a space between main values and outliers).
}
\examples{
set.seed(1)
x <- rnorm(1000)
str(hist_out(x))

# Easy to separate
x2 <- c(x, rnorm(50, mean = 7))
hist(x2, breaks = nclass.scottRob)
str(hist_out(x2))

# More difficult to separate
x3 <- c(x, rnorm(50, mean = 6))
hist(x3, breaks = nclass.scottRob)
str(hist_out(x3))
str(hist_out(x3, nboot = 999))

}
