% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recursiveforecast.R
\name{plot.bigtime.recursiveforecast}
\alias{plot.bigtime.recursiveforecast}
\title{Plots Recursive Forecasts}
\usage{
\method{plot}{bigtime.recursiveforecast}(x, series = NULL, lmbda = NULL, last_n = floor(nrow(fcst$Y) * 0.1), ...)
}
\arguments{
\item{x}{Recursive Forecast obtained using \code{\link{recursiveforecast}}}

\item{series}{Series name. If original data has no names, then use Y1 for
the first series, Y2 for the second, and so on.}

\item{lmbda}{Lambdas to be used for plotting. If forecast was done using only
one lambda, then this will be ignored.}

\item{last_n}{Last \code{n} observations of the original data to include in the plot}

\item{...}{Not currently used}
}
\value{
Returns a ggplot
}
\description{
Plots the recursive forecast obtained using \code{\link{recursiveforecast}}
When forecasts were made for multiple lambdas and \code{lmbda} is not a single
number, then a ribbon will be plotted that reaches from the minimum estimate
of all lambdas to the maximum.
}
\details{
If \code{lmbda} is of length one or forecasts were made using only one lambda,
then only a line will be plotted.

Default names for series are Y1, Y2, ... if the original data does
not have any column names.
}
