% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forward.R
\name{forward}
\alias{forward}
\title{Forward step}
\usage{
forward(data, crit = mbic, ...)
}
\arguments{
\item{data}{an object of class \code{big}.}

\item{crit}{a function defining the model selection criterion. You can use
your own function or one of these: \code{bic}, \code{mbic}, \code{mbic2},
\code{aic}, \code{maic}, \code{maic2}.}

\item{...}{optional arguments to \code{crit}.}
}
\value{
An object of class \code{big}.
}
\description{
Add the best variable to a model according to the given criterion.
}
\details{
Type \code{browseVignettes("bigstep")} for more details.
}
\examples{
set.seed(1)
n <- 30
p <- 10
X <- matrix(rnorm(n * p), ncol = p)
y <- X[, 2] + 2*X[, 3] - X[, 6] + rnorm(n)
d <- prepare_data(y, X)
forward(d, crit = bic)
d \%>\%
  forward() \%>\%
  forward() \%>\%
  forward()

}
