% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FBM.R
\docType{class}
\name{FBM-class}
\alias{FBM-class}
\alias{FBM_RC}
\alias{FBM}
\alias{as_FBM}
\title{Class FBM}
\usage{
FBM(
  nrow,
  ncol,
  type = c("double", "float", "integer", "unsigned short", "unsigned char", "raw"),
  init = NULL,
  backingfile = tempfile(),
  create_bk = TRUE,
  is_read_only = FALSE
)

as_FBM(
  x,
  type = c("double", "float", "integer", "unsigned short", "unsigned char", "raw"),
  backingfile = tempfile(),
  is_read_only = FALSE
)
}
\arguments{
\item{nrow}{Number of rows.}

\item{ncol}{Number of columns.}

\item{type}{Type of the Filebacked Big Matrix (default is \code{double}). Either
\itemize{
\item \code{"double"} (double precision -- 64 bits)
\item \code{"float"} (single precision -- 32 bits)
\item \code{"integer"}
\item \code{"unsigned short"}: can store integer values from 0 to 65535.
It has vocation to become the basis for a \code{FBM.code65536}.
\item \code{"raw"} or \code{"unsigned char"}: can store integer values from 0 to 255.
It is the basis for class \link[=FBM.code256-class]{FBM.code256} in order to
access 256 arbitrary different numeric values.
It is used in \href{https://goo.gl/pHCCmo}{package \strong{bigsnpr}}.
}}

\item{init}{Either a single value (e.g. \code{0}) or as many value as the number
of elements of the FBM. \strong{Default doesn't initialize the matrix.}}

\item{backingfile}{Path to the file storing the Big Matrix on disk.
\strong{An extension ".bk" will be automatically added.}
Default stores in the temporary directory.}

\item{create_bk}{Whether to create a backingfile (the default) or use an
existing one (which should be named by the \code{backingfile} parameter and have
an extension ".bk"). For example, this could be used to convert a
filebacked \code{big.matrix} from package \strong{bigmemory} to a \link[=FBM-class]{FBM}
(see \href{https://privefl.github.io/bigstatsr/articles/bigstatsr-and-bigmemory.html}{the corresponding vignette}).}

\item{is_read_only}{Whether the FBM is read-only? Default is \code{FALSE}.}

\item{x}{A matrix or an data frame (2-dimensional data).}
}
\description{
A reference class for storing and accessing matrix-like data stored in files
on disk. This is very similar to Filebacked Big Matrices provided by the
\strong{bigmemory} package (see \href{https://privefl.github.io/bigstatsr/articles/bigstatsr-and-bigmemory.html}{the corresponding vignette}).

Convert a matrix (or a data frame) to an FBM.
}
\details{
An object of class FBM has many fields:
\itemize{
\item \verb{$address}: address of the external pointer containing the underlying
C++ object for read-only mapping, to be used as a \verb{XPtr<FBM>} in C++ code
\item \verb{$extptr}: (internal) use \verb{$address} instead
\item \verb{$address_rw}: address of the external pointer containing the underlying
C++ object for read/write mapping, to be used as a \verb{XPtr<FBM_RW>} in C++ code
\item \verb{$extptr_rw}: (internal) use \verb{$address_rw} instead
\item \verb{$nrow}: number of rows
\item \verb{$ncol}: number of columns
\item \verb{$type}: (internal) use \code{type_size} or \code{type_chr} instead
\item \verb{$type_chr}: FBM type as character, e.g. "double"
\item \verb{$type_size}: size of FBM type in bytes (e.g. "double" is 8 and "float" is 4)
\item \verb{$backingfile} or \verb{$bk}: File with extension 'bk' that stores the numeric
data of the FBM
\item \verb{$rds}: 'rds' file (that may not exist) corresponding to the 'bk' file
\item \verb{$is_saved}: whether this object is stored in \verb{$rds}?
\item \verb{$is_read_only}: whether it is (not) allowed to modify data?
}

And some methods:
\itemize{
\item \verb{$save()}: Save the FBM object in \verb{$rds}. Returns the FBM.
\item \verb{add_columns(<ncol_add>)}: Add some columns to the FBM by appending the
backingfile with some data. Returns the FBM invisibly.
\item \verb{$bm()}: Get this object as a \code{filebacked.big.matrix}
to be used by package {bigmemory}.
\item \verb{$bm.desc()}: Get this object as a \code{filebacked.big.matrix} descriptor
to be used by package {bigmemory}.
\item \verb{$check_write_permissions()}: Error if the FBM is read-only.
}
}

\examples{
mat <- matrix(1:4, 2)
X_from_mat <- as_FBM(mat)

## You can save this object in an .rds file to use it in another session
X_from_mat$is_saved
X_from_mat$save()
X_from_mat$is_saved
(rds <- X_from_mat$rds)
## Use big_attach() to load the FBM object in another session
X_from_mat <- big_attach(rds)

## Standard accessors
X <- FBM(10, 10)
typeof(X)
X[] <- rnorm(length(X))
X[, 1:6]
X[] <- 1:100
X[, 1]
X[1, ]  # not recommended for large matrices
X[, -1]
X[, c(TRUE, FALSE)]
X[cbind(1:10, 1:10)] <- NA_real_

X[]  # access as standard R matrix

X <- FBM(150, 5)
X[] <- iris   ## you can replace with a df (but factors -> integers)
X2 <- as_FBM(iris)
identical(X[], X2[])

}
\seealso{
\link{big_attach} \link{big_copy}
}
