% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FBM.R
\docType{class}
\name{FBM-class}
\alias{FBM-class}
\alias{FBM_RC}
\alias{FBM}
\title{Class FBM}
\usage{
FBM(nrow, ncol, type = c("double", "integer", "unsigned short",
  "unsigned char", "raw"), init = NULL, backingfile = tempfile(),
  create_bk = TRUE, save = FALSE)
}
\arguments{
\item{nrow}{Number of rows.}

\item{ncol}{Number of columns.}

\item{type}{Type of the Filebacked Big Matrix (default is \code{double}). Either
\itemize{
\item \code{"double"}
\item \code{"integer"}
\item \code{"unsigned short"}: can store integer values from 0 to 65535.
It has vocation to become the basis for a \code{FBM.code65536} class for
accessing strings.
\item \code{"raw"} or \code{"unsigned char"}: can store integer values from 0 to 255.
It is the basis for the \link[=FBM.code256-class]{FBM.code256} class for
accessing 256 arbitrary different numeric values.
It is used in \href{https://goo.gl/pHCCmo}{package bigsnpr}.
}}

\item{init}{Either a single value (e.g. \code{0}) or as many value as the number
of elements of the FBM. \strong{Default doesn't initialize the matrix.}}

\item{backingfile}{Path to the file storing the Big Matrix on disk.
An extension ".bk" will be automatically added. Default stores in the
temporary directory.}

\item{create_bk}{Create a backingfile (the default) or use an existing one
(which should be named by the \code{backingfile} parameter and have an
extension ".bk"). For example, this could be used to convert a filebacked
\code{big.matrix} from package \strong{bigmemory} to a \link[=FBM-class]{FBM}.}

\item{save}{Whether to save the result object in an ".rds" file alongside
the backingfile. Default is \code{FALSE}.}
}
\description{
A reference class for storing and accessing matrix-like data stored in files
on disk. This is very similar to Filebacked Big Matrices provided by the
\strong{bigmemory} package. Yet, the implementation is much more lighter.

Wrapper constructor for class \code{FBM}.
}

\examples{
X <- FBM(10, 10)
typeof(X)
X[] <- rnorm(length(X))
X[, 1:6]
X[] <- 1:100
X[, 1]
X[1, ]  # not recommended for large matrices
X[, -1]
X[, c(TRUE, FALSE)]
X[cbind(1:10, 1:10)] <- NA_real_
X[]

}
