% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/external-software.R
\name{snp_beagleImpute}
\alias{snp_beagleImpute}
\title{Imputation}
\usage{
snp_beagleImpute(
  beagle.path,
  plink.path,
  bedfile.in,
  bedfile.out = NULL,
  memory.max = 3,
  ncores = 1,
  extra.options = "",
  plink.options = "",
  verbose = TRUE
)
}
\arguments{
\item{beagle.path}{Path to the executable of Beagle v4+.}

\item{plink.path}{Path to the executable of PLINK 1.9.}

\item{bedfile.in}{Path to the input bedfile.}

\item{bedfile.out}{Path to the output bedfile. Default is created by
appending \code{"_impute"} to \code{prefix.in} (\code{bedfile.in} without extension).}

\item{memory.max}{Max memory (in GB) to be used. It is internally rounded
to be an integer. Default is \code{3}.}

\item{ncores}{Number of cores used. Default doesn't use parallelism.
You may use \link{nb_cores}.}

\item{extra.options}{Other options to be passed to Beagle as a string. More
options can be found at Beagle's website.}

\item{plink.options}{Other options to be passed to PLINK as a string. More
options can be found at \url{https://www.cog-genomics.org/plink2/filter}.}

\item{verbose}{Whether to show PLINK log? Default is \code{TRUE}.}
}
\value{
The path of the new bedfile.
}
\description{
Imputation using \strong{Beagle} version 4.
}
\details{
Downloads and more information can be found at the following websites
\itemize{
\item \href{https://www.cog-genomics.org/plink2}{PLINK},
\item \href{https://faculty.washington.edu/browning/beagle/beagle.html}{Beagle}.
}
}
\references{
Browning, Brian L., and Sharon R. Browning.
"Genotype imputation with millions of reference samples."
The American Journal of Human Genetics 98.1 (2016): 116-126.
}
\seealso{
\link{download_plink} \link{download_beagle}
}
