% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset-QC.R
\name{subset.bigSNP}
\alias{subset.bigSNP}
\title{Subset}
\usage{
\method{subset}{bigSNP}(x, ind.row = rows_along(G), ind.col = cols_along(G),
  ...)
}
\arguments{
\item{x}{A \link[=bigSNP-class]{bigSNP}.}

\item{ind.row}{Indices of the rows (individuals) to keep.
Negative indices \strong{can} be used to exclude row indices.
Default: keep them all.}

\item{ind.col}{Indices of the columns (SNPs) to keep.
Negative indices \strong{can} be used to exclude column indices.
Default: keep them all.}

\item{...}{Not used.}
}
\value{
The path to the RDS file that stores the \code{bigSNP} object.\cr
Note that this function creates two files whose names have been
automatically chosen by appending "_sub" and a number to the prefix of the
input bigSNP backing files.
}
\description{
A method to get a subset (copy) of a \code{bigSNP}.
This new \code{bigSNP} will also be backed by files (in the same directory).
}
\examples{
str(test <- snp_attachExtdata())

# keep only first 50 samples and SNPs
rdsfile <- subset(test, ind.row = 1:50, ind.col = 1:50)
str(snp_attach(rdsfile))

# remove only first 50 samples and SNPs
rdsfile2 <- subset(test, ind.row = -(1:50), ind.col = -(1:50))
str(snp_attach(rdsfile2))

}
\seealso{
\link[=bigSNP-class]{bigSNP}
}
