% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr.R
\name{src_bigquery}
\alias{src_bigquery}
\title{A BigQuery data source for dplyr.}
\usage{
src_bigquery(project, dataset, billing = project, max_pages = 10)
}
\arguments{
\item{project}{project id or name}

\item{dataset}{dataset name}

\item{billing}{billing project, if different to \code{project}}

\item{max_pages}{(IGNORED) maximum pages returned by a query}
}
\description{
Create the connection to the database with \code{DBI::dbConnect()} then
use \code{\link[dplyr:tbl]{dplyr::tbl()}} to connect to tables within that database. Generally,
it's best to provide the fully qualified name of the table (i.e.
\code{project.dataset.table}) but if you supply a default \code{dataset} in the
connection, you can use just the table name. (This, however, will
prevent you from making joins across datasets.)
}
\examples{
\dontrun{
library(dplyr)

# To run this example, replace billing with the id of one of your projects
# set up for billing
con <- DBI::dbConnect(bigquery(), project = bq_test_project())

shakespeare <- con \%>\% tbl("publicdata.samples.shakespeare")
shakespeare
shakespeare \%>\%
  group_by(word) \%>\%
  summarise(n = sum(word_count, na.rm = TRUE)) \%>\%
  arrange(desc(n))
}
}
