% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bq-job.R
\name{api-job}
\alias{api-job}
\alias{bq_job_meta}
\alias{bq_job_status}
\alias{bq_job_show_statistics}
\alias{bq_job_wait}
\title{BigQuery job: retrieve metadata}
\usage{
bq_job_meta(x, fields = NULL)

bq_job_status(x)

bq_job_show_statistics(x)

bq_job_wait(x, quiet = getOption("bigrquery.quiet"), pause = 0.5)
}
\arguments{
\item{x}{A \link{bq_job}}

\item{fields}{An optional field specification for
\href{https://cloud.google.com/bigquery/docs/api-performance#partial-response}{partial response}}

\item{quiet}{If \code{FALSE}, displays progress bar; if \code{TRUE} is silent;
if \code{NA} displays progress bar only for long-running jobs.}

\item{pause}{amount of time to wait between status requests}
}
\description{
To perform a job, see \link{api-perform}. These functions all retrieve metadata
(in various forms) about an existing job.
}
\section{API documentation}{

\itemize{
\item \href{https://cloud.google.com/bigquery/docs/reference/rest/v2/jobs/get}{get}
}
}

\examples{
if (bq_testable()) {
jobs <- bq_project_jobs(bq_test_project())
jobs[[1]]

# Show statistics about job
bq_job_show_statistics(jobs[[1]])

# Wait for job to complete
bq_job_wait(jobs[[1]])
}
}
