% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.r
\name{query_exec}
\alias{query_exec}
\title{Run a asynchronous query and retrieve results.}
\usage{
query_exec(query, project, destination_table = NULL, default_dataset = NULL,
  page_size = 10000, max_pages = 10, warn = TRUE)
}
\arguments{
\item{query}{SQL query string}

\item{project}{project name}

\item{destination_table}{(optional) destination table for large queries,
either as a string in the format used by BigQuery, or as a list with
\code{project_id}, \code{dataset_id}, and \code{table_id} entries}

\item{default_dataset}{(optional) default dataset for any table references in
\code{query}, either as a string in the format used by BigQuery or as a
list with \code{project_id} and \code{dataset_id} entries}

\item{page_size}{Number of items per page.}

\item{max_pages}{maximum number of pages to retrieve. Use \code{Inf}
to retrieve the complete dataset.}

\item{warn}{If \code{TRUE}, warn when there are rows remaining to
be pulled down from database.}
}
\description{
This is a high-level function that inserts a query job
(with \code{\link{insert_query_job}}), repeatedly checks the status (with
\code{\link{get_job}}) until it is complete, then retrieves the results
(with \code{\link{list_tabledata}})
}
\examples{
\dontrun{
project <- "fantastic-voyage-389" # put your project ID here
sql <- "SELECT year, month, day, weight_pounds FROM [publicdata:samples.natality] LIMIT 5"
query_exec(sql, project = project)
# Put the results in a table you own (which uses project by default)
query_exec(sql, project = project, destination_table = "my_dataset.results")
# Use a default dataset for the query
sql <- "SELECT year, month, day, weight_pounds FROM natality LIMIT 5"
query_exec(sql, project = project, default_dataset = "publicdata:samples")
}
}
\seealso{
Google documentation describing asynchronous queries:
 \url{https://developers.google.com/bigquery/docs/queries#asyncqueries}

 Google documentation for handling large results:
 \url{https://developers.google.com/bigquery/querying-data#largequeryresults}
}

