% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/createPrediction.R
\name{createPrediction}
\alias{createPrediction}
\title{Creating BigML Predictions}
\usage{
createPrediction(model_id, input_field_ids, name = NULL,
  prediction_only = TRUE, ...)
}
\arguments{
\item{model_id}{character string; the model id}

\item{input_field_ids}{a list of input field ids and values to make a
prediction for (see example).}

\item{name}{character string; The given name for the prediction.}

\item{prediction_only}{logical: Indicating whether the prediction should
be returned as a simple value, or if the full response object should be
returned.}

\item{\dots}{Arbitrary named arguments that are passed on to
\code{\link{formEncodeURL}} in order to create form-encoded URL options.}
}
\value{
atomic character or numeric value if prediction_only is TRUE,
else return:
\item{category}{numeric}
\item{code}{numeric}
\item{created}{character}
\item{credits}{numeric}
\item{dataset}{character}
\item{dataset_status}{logical}
\item{description}{character}
\item{fields}{list}
\item{input_data}{numeric}
\item{locale}{character}
\item{model}{character}
\item{model_status}{logical}
\item{name}{character}
\item{objective_fields}{character}
\item{prediction}{character}
\item{prediction_path}{list}
\item{private}{logical}
\item{resource}{character}
\item{source}{character}
\item{source_status}{logical}
\item{status}{list}
\item{tags}{AsIs}
\item{updated}{character}
}
\description{
Creating BigML Predictions
}
\details{
This function needs to use id information from existing R
resources.  See the references for more details.
}
\examples{
\dontrun{
# simple example
m1 = createPrediction("model/1",
	input_field_ids = c('000001'='somevalue', '000002'=9999))
# configure a number of different parameters
m2 = createPrediction("model/2",
	input_field_ids = c('000001'='somevalue', '000002'=9999),
	name='new prediction')
}
}
\author{
Leon Hwang \email{hwang@bigml.com}
}
\references{
\url{https://bigml.com/developers/predictions}
}
\seealso{
Other prediction methods: \code{\link{getPrediction}};
  \code{\link{quickPrediction}}
}

