% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.cv.biglasso.R
\name{summary.cv.biglasso}
\alias{summary.cv.biglasso}
\alias{print.summary.cv.biglasso}
\title{Summarizing inferences based on cross-validation}
\usage{
\method{summary}{cv.biglasso}(object, ...)

\method{print}{summary.cv.biglasso}(x, digits, ...)
}
\arguments{
\item{object}{A \code{cv.biglasso} object.}

\item{\dots}{Further arguments passed to or from other methods.}

\item{x}{A \code{"summary.cv.biglasso"} object.}

\item{digits}{Number of digits past the decimal point to print out.  Can be
a vector specifying different display digits for each of the five
non-integer printed values.}
}
\value{
\code{summary.cv.biglasso} produces an object with S3 class
\code{"summary.cv.biglasso"} which inherits class
\code{"summary.cv.ncvreg"}.  The class has its own print method and contains
the following list elements: \item{penalty}{The penalty used by
\code{biglasso}.} \item{model}{Either \code{"linear"} or \code{"logistic"},
depending on the \code{family} option in \code{biglasso}.} \item{n}{Number
of observations} \item{p}{Number of regression coefficients (not including
the intercept).} \item{min}{The index of \code{lambda} with the smallest
cross-validation error.} \item{lambda}{The sequence of \code{lambda} values
used by \code{cv.biglasso}.} \item{cve}{Cross-validation error (deviance).}
\item{r.squared}{Proportion of variance explained by the model, as estimated
by cross-validation.} \item{snr}{Signal to noise ratio, as estimated by
cross-validation.} \item{sigma}{For linear regression models, the scale
parameter estimate.} \item{pe}{For logistic regression models, the
prediction error (misclassification error).}
}
\description{
Summary method for \code{cv.biglasso} objects.
}
\examples{
## See examples in "cv.biglasso" and "biglasso-package"
}
\seealso{
\code{\link{biglasso}}, \code{\link{cv.biglasso}},
\code{\link{plot.cv.biglasso}}
}
\author{
Yaohui Zeng and Patrick Breheny

Maintainer: Yaohui Zeng <yaohui.zeng@gmail.com>
}
\keyword{models}
\keyword{regression}
