% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uci_quit.R
\name{uci_quit}
\alias{uci_quit}
\title{Sending quit command to chess engine}
\usage{
uci_quit(engine)
}
\arguments{
\item{engine}{engine object}
}
\value{
strings from uci chess engine GUI
}
\description{
Sending quit command to chess engine and cleaning temps from R
}
\examples{
\donttest{
# Linux (make sure you have executable permission):
engine_path <- "./stockfish_10_x64"
# Windows
# engine_path <- "./stockfish_10_x64.exe"
e <- uci_engine(engine_path)
uci_quit(e)
# Using pipe '\%>\%' from magrittr:
require(magrittr)
uci_engine(engine_path) \%>\% uci_quit()}
}
