% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uci_cmd.R
\name{uci_cmd}
\alias{uci_cmd}
\title{Sending command to chess engine}
\usage{
uci_cmd(engine, command = "")
}
\arguments{
\item{engine}{engine object}

\item{command}{string command}
}
\value{
engine object
}
\description{
Sending command to chess engine
}
\examples{
\donttest{
# Linux (make sure you have executable permission):
engine_path <- "./stockfish_10_x64"
# Windows
# engine_path <- "./stockfish_10_x64.exe"
e <- uci_engine(engine_path)
e <- uci_command(e,"go depth 10")
uci_quit(e)
# Using pipe '\%>\%' from magrittr:
require(magrittr)
uci_engine(engine_path) \%>\% uci_command("go depth 10") \%>\% uci_quit()}
}
