% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{bqr_query}
\alias{bqr_query}
\title{Query a BigQuery Table}
\usage{
bqr_query(projectId = bq_get_global_project(),
  datasetId = bq_get_global_dataset(), query, maxResults = 1000,
  useLegacySql = TRUE, useQueryCache = TRUE)
}
\arguments{
\item{projectId}{The BigQuery project ID}

\item{datasetId}{A datasetId within projectId}

\item{query}{BigQuery SQL}

\item{maxResults}{Max number per page of results. Set total rows with LIMIT in your query.}

\item{useLegacySql}{Whether the query you pass is legacy SQL or not. Default TRUE}

\item{useQueryCache}{Whether to use the query cache. Default TRUE, set to FALSE for realtime queries.}
}
\value{
a data.frame. 
  If there is an SQL error, a data.frame with 
  additional class "bigQueryR_query_error" and the 
  problem in the data.frame$message
}
\description{
MaxResults is how many results to return per page of results, which can be less than the 
total results you have set in your  query using LIMIT.  Google recommends for bigger datasets
to set maxResults = 1000, but this will use more API calls.
}
\examples{

\dontrun{

bqr_query("big-query-r","samples",
          "SELECT COUNT(repository.url) FROM [publicdata:samples.github_nested]")

}

}
\seealso{
\href{https://cloud.google.com/bigquery/sql-reference/}{BigQuery SQL reference}
}
