% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Mmodel_pcar.R
\name{Mmodel_pcar}
\alias{Mmodel_pcar}
\title{Proper multivariate CAR latent effect}
\usage{
Mmodel_pcar(
  cmd = c("graph", "Q", "mu", "initial", "log.norm.const", "log.prior", "quit"),
  theta = NULL
)
}
\arguments{
\item{cmd}{Internal functions used by the \code{rgeneric} model to define the latent effect.}

\item{theta}{Vector of hyperparameters.}
}
\value{
This is used internally by the \code{INLA::inla.rgeneric.define()} function.
}
\description{
M-model implementation of the proper multivariate CAR latent effect with different spatial autocorrelation parameters using the \code{rgeneric} model of INLA.
}
\details{
This function considers a proper CAR prior (denoted as pCAR) for the spatial latent effects of the different diseases and introduces correlation between them using the M-model proposal of \insertCite{botella2015unifying;textual}{bigDM}.
Putting the spatial latent effects for each disease in a matrix, the between disease dependence is introduced through the M matrix as \eqn{\Theta=\Phi M}, where the columns of \eqn{\Phi} follow a pCAR prior distribution (within-disease correlation).
A Wishart prior for the between covariance matrix \eqn{M'M} is considered using the Bartlett decomposition.
Uniform prior distributions on the interval [\code{alpha.min}, \code{alpha.max}] are considered for all the spatial autocorrelation parameters.
\cr\cr
The following arguments are required to be defined before calling the functions:
\itemize{
\item \code{W}: binary adjacency matrix of the spatial areal units
\item \code{J}: number of diseases
\item \code{initial.values}: initial values defined for the cells of the M-matrix
\item \code{alpha.min}: lower limit defined for the uniform prior distribution of the spatial smoothing parameters
\item \code{alpha.max}: upper limit defined for the uniform prior distribution of the spatial smoothing parameters
}
}
\note{
The M-model implementation of this model using R-INLA requires the use of \eqn{J \times (J+3)/2} hyperparameters. So, the results must be carefully checked.
}
\references{
\insertRef{botella2015unifying}{bigDM}
}
