% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pubmed2df.R
\name{pubmed2df}
\alias{pubmed2df}
\title{Convert a PubMed/MedLine collection into a data frame}
\usage{
pubmed2df(D)
}
\arguments{
\item{D}{is an object of class MedLine (package "RISmed") containing data resulting of a query performed on MedLine using the package RISmed.}
}
\value{
a data frame with cases corresponding to articles and variables to Field Tags as proposed by Clarivate Analytics WoS.
}
\description{
It converts a PubMed/MedLine collection (obtained through a query performed with RISmed package) and create a data frame from it, with cases corresponding to articles and variables to Field Tags as proposed by Clarivate Analytics WoS.
}
\examples{
# library(RISmed)
# search_topic <- 'epidermolysis bullosa'
# search_query <- EUtilsSummary(search_topic, retmax=200, mindate=2014, maxdate=2014)
# summary(search_query)
# D <- EUtilsGet(search_query)

# M <- pubmed2df(D)

}
\seealso{
\code{\link{scopus2df}} for converting SCOPUS Export file (in bibtex format)

\code{\link{isi2df}} for converting Clarivate Analitics WoS Export file (in plaintex format)

\code{\link{isibib2df}} for converting Clarivate Analitics WoS Export file (in bibtex format)

Other converting functions: \code{\link{convert2df}},
  \code{\link{isi2df}}, \code{\link{isibib2df}},
  \code{\link{scopus2df}}
}
