% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intern__gibbs_toggle_ar.R
\name{gibbs_toggle_ar}
\alias{gibbs_toggle_ar}
\title{Gibbs sampler for corrected parametric likelihood + Bernstein-Dirichlet mixture}
\usage{
gibbs_toggle_ar(data, Ntotal, burnin, thin = 1, M = 1, g0.alpha = 1,
  g0.beta = 1, k.theta = 0.01, tau.alpha = 0.001, tau.beta = 0.001,
  kmax = 100, L = max(20, length(data)^(1/3)), corrected = TRUE,
  prior.q = FALSE, alpha.toggle = F, toggle = FALSE, Nadaptive = 0,
  adaption.batchSize = 50, adaption.targetAcceptanceRate = 0.44,
  mu.prop = NULL, var.prop.rho = NULL, AR.fit = NULL, MA.fit = NULL,
  dist = "normal", kurt.toggle = TRUE, kurt.lambda = 0.1,
  kurt.thresh = 6/96, kurt.star.alpha = NULL, kurt.star.beta = NULL,
  kurt.fit = NULL, beta.toggle = F, beta.alpha = 2,
  beta.beta = beta.alpha/2, beta.fit = NULL, rho.alpha = rep(1,
  length(mu.prop)), rho.beta = rep(1, length(mu.prop)))
}
\description{
Gibbs sampler for corrected parametric likelihood + Bernstein-Dirichlet mixture
}
\keyword{internal}

