% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bexy.R
\name{plotXY}
\alias{plotXY}
\title{Plotting the counts of a bexy object, colored by sex karyotype}
\usage{
plotXY(
  x,
  colors = c("turquoise3", "darkorange", "royalblue4"),
  sampleNamesToHighlight = c(),
  label = TRUE,
  ...
)
}
\arguments{
\item{x}{A bexy object.}

\item{colors}{A vector of length three with the colors for aneuploid, XX and XY samples, respectively.}

\item{sampleNamesToHighlight}{A vector of sample names that should be highlighted. If empty, samples are automatically highlighted based on the posterior probabilites.}

\item{label}{Boolean indicating whether samples should be labeled.}

\item{...}{Other parameters used for plotting.}
}
\value{
No return value, called for side effects.
}
\description{
Plotting the counts of a bexy object, colored by sex karyotype
}
\examples{
bex <- bexy()
plotXY(bex)
}
\seealso{
\code{\link{bexy}}
}
