% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betafunctions.R
\name{betamedian}
\alias{betamedian}
\title{Compute Median of Two- and Four-Parameter Beta Probability Density distribution.}
\usage{
betamedian(alpha, beta, l = 0, u = 1)
}
\arguments{
\item{alpha}{The alpha shape parameter.}

\item{beta}{The beta shape parameter.}

\item{l}{The first (lower) location parameter. Default set to \code{0}.}

\item{u}{The second (upper) location parameter. Default set to \code{1}.}
}
\description{
Computes the median of a Beta distribution with specified shape- and location parameters.
}
\examples{
# To calculate the median of a two-parameter (standard) Beta distribution with
# shape parameters alpha = 5 and beta = 3:
betamedian(alpha = 5, beta = 3)

# To calculate the median of a four-parameter Beta distribution with shape
# parameters alpha = 5 and beta = 3, and location parameters l = 25 and
# u = 150:
betamedian(alpha = 5, beta = 3, l = 25, u = 150)
}
