% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{ccStats}
\alias{ccStats}
\title{Classification Consistency Statistics.}
\usage{
ccStats(ii, ij, ji, jj)
}
\arguments{
\item{ii}{The frequency or rate of consistent classifications into category "i".}

\item{ij}{The frequency or rate of inconsistent classifications into categories "i" and "j".}

\item{ji}{The frequency or rate of inconsistent classifications into categories "j" and "i".}

\item{jj}{The frequency or rate of consistent classifications into category "j".}
}
\value{
A list of classification consistency statistics. Specifically, the coefficient of consistent classification (p), the coefficient of consistent classification by chance (p_c), and Cohen's Kappa coefficient.
}
\description{
Provides a set of statistics often used for conveying information regarding the consistency of classifications based on tests.
}
\examples{
# Generate some fictional data. Say, 100 individuals take a test with a
# maximum score of 100 and a minimum score of 0.
set.seed(1234)
testdata <- rbinom(100, 100, rBeta.4P(100, .25, .75, 5, 3))
hist(testdata, xlim = c(0, 100))

# Suppose the cutoff value for attaining a pass is 50 items correct, and
# that the reliability of this test was estimated to 0.7. First, compute the
# estimated consistency matrix using LL.CA():
cmat <- LL.CA(x = testdata, reliability = .7, cut = 50, min = 0,
max = 100)$consistencymatrix

# To estimate and retrieve consistency statistics using ccStats(),
# feed it the appropriate entries of the consistency matrix.
ccStats(ii = cmat["i", "i"], ij = cmat["i", "j"],
ji = cmat["j", "i"], jj = cmat["j", "j"])
}
\references{
Hanson, Bradley A. (1991). Method of Moments Estimates for the Four-Parameter Beta Compound Binomial Model and the Calculation of Classification Consistency Indexes. American College Testing.
}
