% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step_orderNorm.R
\name{step_orderNorm}
\alias{step_orderNorm}
\alias{tidy.step_orderNorm}
\alias{axe_env.step_orderNorm}
\title{ORQ normalization (orderNorm) for \code{recipes} implementation}
\usage{
step_orderNorm(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  transform_info = NULL,
  transform_options = list(),
  num_unique = 5,
  skip = FALSE,
  id = rand_id("orderNorm")
)

\method{tidy}{step_orderNorm}(x, ...)

\method{axe_env}{step_orderNorm}(x, ...)
}
\arguments{
\item{recipe}{A formula or recipe}

\item{...}{One or more selector functions to choose which variables are
affected by the step. See [selections()] for more details. For the `tidy`
method, these are not currently used.}

\item{role}{Not used by this step since no new variables are created.}

\item{trained}{For recipes functionality}

\item{transform_info}{A numeric vector of transformation values. This (was
transform_info) is `NULL` until computed by [prep.recipe()].}

\item{transform_options}{options to be passed to orderNorm}

\item{num_unique}{An integer where data that have less possible values will
not be evaluate for a transformation.}

\item{skip}{For recipes functionality}

\item{id}{For recipes functionality}

\item{x}{A `step_orderNorm` object.}
}
\value{
An updated version of `recipe` with the new step added to the
  sequence of existing steps (if any). For the `tidy` method, a tibble with
  columns `terms` (the selectors or variables selected) and `value` (the
  lambda estimate).
}
\description{
`step_orderNorm` creates a specification of a recipe step (see
  `recipes` package) that will transform data using the ORQ (orderNorm)
  transformation, which approximates the "true" normalizing transformation if
  one exists. This is considerably faster than `step_bestNormalize`.
}
\details{
The orderNorm transformation can be used to rescale a variable to be
  more similar to a normal distribution. See `?orderNorm` for more
  information; `step_orderNorm` is the implementation of `orderNorm` in the
  `recipes` context.
  
  As of version 1.7, the `butcher` package can be used to (hopefully) improve 
  scalability of this function on bigger data sets.
}
\examples{
library(recipes)
rec <- recipe(~ ., data = as.data.frame(iris))

orq_trans <- step_orderNorm(rec, all_numeric())

orq_estimates <- prep(orq_trans, training = as.data.frame(iris))

orq_data <- bake(orq_estimates, as.data.frame(iris))

plot(density(iris[, "Petal.Length"]), main = "before")
plot(density(orq_data$Petal.Length), main = "after")

tidy(orq_trans, number = 1)
tidy(orq_estimates, number = 1)


}
\references{
Ryan A. Peterson (2019). Ordered quantile normalization: a
  semiparametric transformation built for the cross-validation era. Journal
  of Applied Statistics, 1-16.
}
\seealso{
\code{\link[bestNormalize]{orderNorm}} \code{\link{bestNormalize}},
  [recipe()] [prep.recipe()] [bake.recipe()]
}
\concept{preprocessing}
\concept{transformation_methods}
