% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step_best_normalize.R
\name{step_best_normalize}
\alias{step_best_normalize}
\alias{step_bestNormalize}
\alias{step_bestNormalize_new}
\alias{tidy.step_best_normalize}
\alias{axe_env.step_best_normalize}
\title{Run bestNormalize transformation for \code{recipes} implementation}
\usage{
step_best_normalize(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  transform_info = NULL,
  transform_options = list(),
  num_unique = 5,
  skip = FALSE,
  id = rand_id("best_normalize")
)

\method{tidy}{step_best_normalize}(x, ...)

\method{axe_env}{step_best_normalize}(x, ...)
}
\arguments{
\item{recipe}{A formula or recipe}

\item{...}{One or more selector functions to choose which variables are
affected by the step. See [selections()] for more details. For the `tidy`
method, these are not currently used.}

\item{role}{Not used by this step since no new variables are created.}

\item{trained}{For recipes functionality}

\item{transform_info}{A numeric vector of transformation values. This (was
transform_info) is `NULL` until computed by [prep.recipe()].}

\item{transform_options}{options to be passed to bestNormalize}

\item{num_unique}{An integer where data that have less possible values will
not be evaluate for a transformation.}

\item{skip}{For recipes functionality}

\item{id}{For recipes functionality}

\item{x}{A `step_best_normalize` object.}
}
\value{
An updated version of `recipe` with the new step added to the
  sequence of existing steps (if any). For the `tidy` method, a tibble with
  columns `terms` (the selectors or variables selected) and `value` (the
  lambda estimate).
}
\description{
`step_best_normalize` creates a specification of a recipe step
  (see `recipes` package) that will transform data using the best of a suite
  of normalization transformations estimated (by default) using
  cross-validation.
}
\details{
The bestnormalize transformation can be used to rescale a variable
  to be more similar to a normal distribution. See `?bestNormalize` for more
  information; `step_best_normalize` is the implementation of `bestNormalize`
  in the `recipes` context. 
  
  As of version 1.7, the `butcher` package can be used to (hopefully) improve 
  scalability of this function on bigger data sets.
}
\examples{

library(recipes)
rec <- recipe(~ ., data = as.data.frame(iris))

bn_trans <- step_best_normalize(rec, all_numeric())

bn_estimates <- prep(bn_trans, training = as.data.frame(iris))

bn_data <- bake(bn_estimates, as.data.frame(iris))

plot(density(iris[, "Petal.Length"]), main = "before")
plot(density(bn_data$Petal.Length), main = "after")

tidy(bn_trans, number = 1)
tidy(bn_estimates, number = 1)

}
\seealso{
\code{\link[bestNormalize]{bestNormalize}} \code{\link{orderNorm}},
  [recipe()] [prep.recipe()] [bake.recipe()]
}
\concept{preprocessing}
\concept{transformation_methods}
