% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colPointsHist.R
\name{colPointsHist}
\alias{colPointsHist}
\title{Histogram for colPoints}
\usage{
colPointsHist(z, nbins = 40, colors = seqPal(nbins), bb = seqR(z,
  length.out = nbins + 1), at = pretty2(z), labels = at, bg = "white",
  x1 = 0, x2 = 0.4, y1 = 0, y2 = 0.3, outer = FALSE, mar = c(2, 2,
  1, 0.5), mgp = c(1.8, 0.6, 0), sborder = NA, resetfocus = TRUE,
  breaks = 20, freq = TRUE, col = par("fg"), border = NA, main = "",
  ylab = "", xlab = "", las = 1, axes = TRUE, ...)
}
\arguments{
\item{z}{Values of third dimension used in \code{\link{colPoints}}}

\item{nbins}{Number of classes (thus, colors). DEFAULT: 40}

\item{colors}{Colors that are used for the background. DEFAULT: seqPal(nbins)}

\item{bb}{Borders of bins for the background. DEFAULT: seqR(z, length.out=nbins+1)}

\item{at}{Positions of x-axis labels. DEFAULT: pretty2(z)}

\item{labels}{X-axis labels themselves. DEFAULT: at}

\item{bg}{Background behind background and axis labels. DEFAULT: "white"}

\item{x1, x2, y1, y2}{Relative coordinates [0:1] of inset plot, see \code{\link{smallPlot}}. 
DEFAULT: x: 0-0.3, y: 0-0.4}

\item{outer}{Logical: Should legend be relative to device instead of current figure?
use outer=TRUE when par(mfrow, oma) is set. DEFAULT: FALSE}

\item{mar}{Margins for \code{\link{smallPlot}}. DEFAULT: c(2, 2, 1, 0.5)}

\item{mgp}{MarGinPlacement: distance of xlab/ylab, numbers and line from plot margin, 
as in \code{\link{par}}, but with different defaults. DEFAULT: c(1.8, 0.6, 0)}

\item{sborder}{Border around inset subplot. DEFAULT: par("fg")}

\item{resetfocus}{Reset focus to original plot? Specifies where further 
low level plot commands are directed to. DEFAULT: TRUE}

\item{breaks}{Breaks as in \code{\link{hist}}, but with a different default. DEFAULT: 20}

\item{freq}{Plot count data in hist? (if FALSE, plot density instead). DEFAULT: TRUE}

\item{col}{Color of histogram bars. DEFAULT: par("fg")}

\item{border}{Border around each bar. DEFAULT: NA}

\item{main, ylab, xlab}{Labels. DEFAULT: ""}

\item{las}{LabelAxisStyle. DEFAULT: 1}

\item{axes}{Draw axes?. DEFAULT: TRUE}

\item{\dots}{Further arguments passed to \code{\link{hist}}. NOT POSSIBLE: \code{x, add}}
}
\value{
invisible list of par of smallPlot, adds histogram to current plot
}
\description{
Adds Histogram to plots created or enhanced with \code{\link{colPoints}}
}
\examples{

z <- rnorm(50)
plot(1:10)
colPointsHist(z=z)

}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Aug 2014
}
\seealso{
\code{\link{colPointsLegend}} and \code{\link{colPoints}} for real life examples
}
\keyword{aplot}
\keyword{color}

