% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benchmark_parallel.R
\name{bm_parallel}
\alias{bm_parallel}
\title{Benchmark in parallel}
\usage{
bm_parallel(bm, runs, verbose, cores, ...)
}
\arguments{
\item{bm}{character name of benchmark function to run from \code{\link{get_available_benchmarks}}}

\item{runs}{number of runs of benchmark to make}

\item{verbose}{display messages during benchmarking}

\item{cores}{number of cores to benchmark}

\item{...}{additional arguments to pass to \code{bm}}
}
\description{
When a user specifies cores, the benchmark will be run on a 
maximum number of cores, and all counts descending in powers of 2 from that 
maximum. If a user specifies 6 cores, then the benchmarks will be repeated 
for 6 core, 4 core, 2 core, and finally single core performance.
}
\details{
This function runs benchmarks in parallel to test multithreading
}
\examples{
\dontrun{
bm_parallel("bm_matrix_cal_manip", runs = 3, verbose = TRUE, cores = 2)
bm = c("bm_matrix_cal_manip","bm_matrix_cal_power", "bm_matrix_cal_sort", 
       "bm_matrix_cal_cross_product", "bm_matrix_cal_lm")
results = lapply(bm, bm_parallel, 
                runs = 5, verbose = TRUE, cores = 2L)
}
}
