% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/potential_for_change_index.R
\name{potential_for_change_index}
\alias{potential_for_change_index}
\title{Potential for Change Index}
\usage{
potential_for_change_index(
  data,
  determinants,
  target,
  type = "sample-level 1",
  minimum = NULL,
  maximum = NULL,
  center = NULL,
  weight = NULL
)
}
\arguments{
\item{data}{The dataframe containing the variables.}

\item{determinants}{The name(s) of the determinant(s).}

\item{target}{The target (e.g. behavior or intention).}

\item{type}{The type of potential for change index. Currently implemented
are \code{'sample-level 1'} and \code{'sample-level 2'} - see details for more
information.}

\item{minimum, maximum}{The functions to return the minimum and maximum to
use in the computation. If \code{NULL}, \code{\link[=min]{min()}} and \code{\link[=max]{max()}} are used
with \code{na.rm=TRUE}.}

\item{center}{The function to return the central tendency estimate to use
in the computation. If \code{NULL}, \code{\link[=mean]{mean()}} is used with \code{na.rm=TRUE}.}

\item{weight}{The function to return the weight/multiplier to use in the
computation. If \code{NULL}, \code{\link[stats:cor]{stats::cor()}} is used with \code{use="complete.obs"}.}
}
\value{
If one determinant, the potential for change index for that
detreminant; if multiple, a list with those indices.
}
\description{
Computes the Potential for change index for one or multiple determinants.
}
\details{
The Potential for Change index was developed by Keegan et al. and is a
numerical representation of a number of important features in \code{\link[=CIBER]{CIBER()}}
plots (for more details, please see the references below).

The original Potential for Change Index was conceptualized to optimize
intervention tailoring and improve the prediction of individual-level
intervention effectiveness. This function currently only computes two
sample-level variants that can facilitate sub-determinant selection.

The first (\code{type = 'sample-level 1'}) is computed as follows:
\itemize{
\item For sub-determinants with a positive zero-order correlation with
behavior, the sample mean was subtracted from the observed maximum score,
and the result was multiplied by the zero-order correlation;
\item For sub-determinants with a negative zero-order correlation with
behavior, the sample mean was subtracted from the observed minimum score,
and the result was multiplied by the zero-order correlation.
}

The second (\code{type = 'sample-level 2'}) is computed as follows:
\itemize{
\item For sub-determinants with a positive zero-order correlation with
behavior, the sample mean was subtracted from the .95 quantile of the
scores, and the result was multiplied by the squared zero-order
correlation (i.e. the proportion of explained variance);
\item For sub-determinants with a negative zero-order correlation with
behavior, the sample mean was subtracted from the .05 quantile of the
scores, and the result was multiplied by the squared zero-order
correlation (i.e. the proportion of explained variance);
}

The second variant effectively takes the 5\% trimmed maximum and minimum,
rendering it less sensitive to outliers, penalizes weak associations with
behavior more severely, and decreases sensitivity to differences between
correlations. These differences should render the second variant a bit more
robust over different samples.
}
\examples{
dat <- get(data("BBC_pp15.1", package="behaviorchange"))
behaviorchange::potential_for_change_index(
  data=dat,
  determinants='highDose_attitude',
  target='highDose_intention'
);

### Or for multiple determinants
behaviorchange::potential_for_change_index(
  data=dat,
  determinants=c('highDose_attitude', 'highDose_perceivedNorm'),
  target='highDose_intention'
);

### Get the Potential for Change Index Type 2
behaviorchange::potential_for_change_index(
  data=dat,
  determinants=c('highDose_attitude', 'highDose_perceivedNorm'),
  target='highDose_intention',
  type = 'sample-level 2'
);

}
\references{
Knittle, K. P., Peters, G.-J. Y., Heino, M. T. J., Tobias, R., &
Hankonen, N. (2019). Potential for change: New metrics for tailoring and
predicting response to behavior change interventions. \doi{10/ghqmg3}
}
