% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_beast2_version_cmd.R
\name{create_beast2_version_cmd_bin}
\alias{create_beast2_version_cmd_bin}
\title{Creates the terminal command to version a BEAST2 input file
using a call to the \code{launcher.jar} file}
\usage{
create_beast2_version_cmd_bin(beast2_bin_path = get_default_beast2_bin_path())
}
\arguments{
\item{beast2_bin_path}{name of the BEAST2 binary file
(usually simply \code{beast}).
Use \link{get_default_beast2_bin_path} to get
the default BEAST binary file's path}
}
\value{
a character vector, of which the first element
  is the command (\code{java}, in this case),
  and the others are arguments (\code{-jar}, in this case, followed
  by more arguments.
}
\description{
Creates the terminal command to version a BEAST2 input file
using a call to the \code{launcher.jar} file
}
\examples{
  if (is_beast2_installed() && is_on_ci()) {
    cmds <- create_beast2_version_cmd_bin()
    testit::assert(length(cmds) == 2)
    testit::assert(cmds[2] == "-version")
  }
}
\author{
Richèl J.C. Bilderbeek
}
