% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapgrid.R
\name{mapgrid}
\alias{mapgrid}
\title{Maps the data points on the map in grid format}
\usage{
mapgrid(indf = NA, ptype = "records", title = "", bbox = NA,
  legscale = 0, collow = "blue", colhigh = "red", mapdatabase = "world",
  region = ".", gridscale = 1, customize = NULL)
}
\arguments{
\item{indf}{input data frame containing biodiversity data set}

\item{ptype}{Type of map on the grid. Accepted values are "presence" for 
presence/absence maps, "records" for record-density map, "species" for 
species-density map and "complete" for completeness map}

\item{title}{title for the map. There is no default title}

\item{bbox}{bounding box for the map in format c(xmin,xmax,ymin,ymax)}

\item{legscale}{Set legend scale to a higher value than the max value in the 
data}

\item{collow}{Color for lower range in the color ramp of the grid}

\item{colhigh}{Color for higher range in the color ramp of the grid}

\item{mapdatabase}{database to be used. By default, the world database is 
used}

\item{region}{Specific region(s) to map, like countries. Default is the whole
world map}

\item{gridscale}{plot the map grids at specific degree scale. Default is 1. 
Currently valid values are 1 and 0.1.}

\item{customize}{additional customization string to customize the map output 
using ggplot2 parameters}
}
\description{
Customizable grid-based spatial representation of the coordinates of the 
records in the data set.
}
\details{
This function builds a grid map colored according to the density of records 
in each cell. Grids are 1-degree cells, build with the 
\code{\link{getcellid}} function. Currently, four types of maps can be 
rendered. Presence maps show only if the cell is populated or not, without 
paying attention to how many records or species are present. Record-density 
maps apply a color gradient according to the number of records in the cell, 
regardless of the number of species they represent. Species-density maps apply 
a color gradient according to the number of different species in the cell, 
regardless of how many records there are for each one of those. Completeness 
maps apply a color gradient according to the completeness index, from 0
(incomplete) to 1 (complete).

See parameter descriptions for ways of customizing the map.
}
\examples{
\dontrun{
mapgrid(inat,ptype="records", region="India")
}
}
\seealso{
Other Spatial visualizations: \code{\link{bdwebmap}}
}
