% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operator-pipe.R
\docType{methods}
\name{operator-pipe}
\alias{operator-pipe}
\alias{\%>|\%}
\title{bdpar customized forward-pipe operator}
\usage{
lhs \%>|\% rhs
}
\arguments{
\item{lhs}{an \code{\link{Instance}} object.}

\item{rhs}{a function call using the bdpar semantics.}
}
\value{
The \code{\link{Instance}} modified by the methods it has traversed.
}
\description{
Defines a customized forward pipe operator extending the
features of classical \%>\%. Concretely \%>|\% is able to stop the pipelining
process whenever an \code{\link{Instance}} has been invalidated. This issue,
avoids executing the whole pipelining process for the invalidated
\code{\link{Instance}} and therefore reduce the time and resources used to
complete the whole process.
}
\section{Details}{

This is the \%>\% operator of the modified magrittr library to both
(i) to stop the flow when the \code{\link{Instance}} is invalid and (ii)
automatically call the \code{pipe} function of the R6 objects passing
through it (iii) to check the dependencies of the \code{\link{Instance}} and
(iv) to manage the pipeline cache.

The usage structure would be as shown below:

\preformatted{
instance \%>|\%

pipeObject$new() \%>|\%

pipeObject$new(<<argument1>>, <<argument2>, ...) \%>|\%

pipeObject$new()
}
}

\section{Note}{

Pipelining process is automatically stopped if the \code{\link{Instance}}
is invalid.
}

\seealso{
\code{\link{bdpar.Options}}, \code{\link{Instance}},
\code{\link{GenericPipe}}
}
