% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_subjects.R
\name{search_subjects}
\alias{search_subjects}
\title{Search for subject codes}
\usage{
search_subjects(
  name,
  sort = c("id", "-id", "name", "-name"),
  lang = c("pl", "en"),
  ...
)
}
\arguments{
\item{name}{A phrase to search.}

\item{sort}{A type of sorting, "id" (default), "-id", "name", "-name"}

\item{lang}{A language of returned data, "pl" (default), "en"}

\item{...}{Other arguments passed on to \code{\link[httr]{GET}}. For example
a proxy parameters, see details.}
}
\value{
A dataset as a tibble.
}
\description{
Search for given phrase in subject names
}
\details{
To use a proxy to connect, a \code{\link[httr]{use_proxy}} can be
  passed to \code{\link[httr]{GET}}. For example
  \code{get_request(id, filters,
  config = httr::use_proxy(url, port, username, password))}.
}
\examples{
 \donttest{
    search_subjects("samochody")
    search_subjects("cars", lang  = "en")
}
}
\keyword{seach}
\keyword{subjects}
\keyword{utilities}
