% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdc_year_outOfRange.R
\name{bdc_year_outOfRange}
\alias{bdc_year_outOfRange}
\title{Identify records with year out-of-range}
\usage{
bdc_year_outOfRange(data, eventDate, year_threshold = 1900)
}
\arguments{
\item{data}{A data frame containing a column with event date information.}

\item{eventDate}{numeric or date. The column containing event date
information.}

\item{year_threshold}{numeric. A four-digit year threshold used to flag old
(potentially invalid) records. Default = 1900}
}
\value{
A data.frame containing the column ".year_outOfRange". Compliant
(TRUE) if 'eventDate' is not out-of-range; otherwise "FALSE".
}
\description{
This function identifies records out-of-range collecting year (e.g., in the
future) or old records collected before a year informed in 'year_threshold'.
}
\details{
Following the "VALIDATION:YEAR_OUTOFRANGE"
\href{https://github.com/tdwg/bdq/projects/2}{Biodiversity data quality
group}, the results of this test are time-dependent. While the user may
provide a lower limit to the year, the upper limit is defined based on the
year when the test is run. Lower limits can be used to flag old, often
imprecise, records. For example, records collected before GPS advent
(1980). If 'year_threshold' is not provided, the lower limit to the year is
by default 1600, a lower limit for collecting dates of biological specimens.
Records with empty or NA 'eventDate' are not tested and returned as NA.
}
\examples{
collection_date <- c(
  NA, "31/12/2029", "2013-06-13T00:00:00Z", "2013-06-20",
  "", "2013", 1650, "0001-01-00"
)
x <- data.frame(collection_date)

bdc_year_outOfRange(
data = x, 
eventDate = "collection_date", 
year_threshold = 1900)

}
\seealso{
Other time: 
\code{\link{bdc_eventDate_empty}()},
\code{\link{bdc_year_from_eventDate}()}
}
\concept{time}
