% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdc_coordinates_empty.R
\name{bdc_coordinates_empty}
\alias{bdc_coordinates_empty}
\title{Identify records with empty geographic coordinates}
\usage{
bdc_coordinates_empty(data, lat = "decimalLatitude", lon = "decimalLongitude")
}
\arguments{
\item{data}{data.frame. Containing geographical coordinates.}

\item{lat}{character string. The column name with latitude in decimal degrees
and WGS84. Default = "decimalLatitude".}

\item{lon}{character string. The column with longitude in decimal degrees and
WGS84. Default = "decimalLongitude".}
}
\value{
A data.frame containing the column ".coordinates_empty". Compliant
(TRUE) if 'lat' and 'lon' are not empty; otherwise "FALSE".
}
\description{
This function flags records missing latitude or longitude coordinates.
}
\details{
This test identifies records missing geographic coordinates (i.e.,
empty or not applicable \link{NA} longitude or latitude)
}
\examples{
x <- data.frame(
  decimalLatitude = c(19.9358, -13.016667, NA, ""),
  decimalLongitude = c(-40.6003, -39.6, -20.5243, NA)
)

bdc_coordinates_empty(
  data = x,
  lat = "decimalLatitude",
  lon = "decimalLongitude"
)

}
\seealso{
Other prefilter: 
\code{\link{bdc_basisOfRecords_notStandard}()},
\code{\link{bdc_coordinates_country_inconsistent}()},
\code{\link{bdc_coordinates_from_locality}()},
\code{\link{bdc_coordinates_outOfRange}()},
\code{\link{bdc_coordinates_transposed}()},
\code{\link{bdc_country_standardized}()},
\code{\link{bdc_scientificName_empty}()}
}
\concept{prefilter}
